document.addEventListener('DOMContentLoaded', function(){
    var divs_shippings = $('.customer.card .info-block-col');
    
	async function getPhoneNumbers()
	{
        let id_order = $('.title-row strong.text-muted').text().replace('#', '');

        return new Promise((resolve, reject) => {
            $.ajax({
                url: 'ajax-tab.php',
                dataType: 'JSON',
                data: {
                    action: 'GetPhoneNumberFromOrder',
                    controller : 'AdminAgWpButtonAddress',
                    ajax : true,
                    token: agwpbutton_address_token,
                    id_order: id_order
                },
                success: function(data) {
                    if (typeof data.success && data.success && data.phone != '') {
                        resolve(data.phones);
                    } else {
                        reject(data.error);
                    }
                },
                error: reject
            });
        });
	}

	async function addWpButtonsToDiv(divs_shippings)
	{
        let phones = await getPhoneNumbers();

        let link = $('<a/>', {
            'href' : 'https://api.whatsapp.com/send?phone=' + phones.invoice,
            'target': '_blank',
            'class' : 'btn btn-primary agwpbutton',
            'text'  :' WhatsApp'
        });

        $('<i/>', {
            class: 'material-icons',
            text : 'chat_bubble'
        }).prependTo(link);
        link.appendTo(divs_shippings[0]);


        link = $('<a/>', {
            'href' : 'https://api.whatsapp.com/send?phone=' + phones.delivery,
            'target': '_blank',
            'class' : 'btn btn-primary agwpbutton',
            'text' : ' WhatsApp'
        });
        
        $('<i/>', {
            class: 'material-icons',
            text : 'chat_bubble'
        }).prependTo(link);

        link.appendTo(divs_shippings[1]);
	}

	addWpButtonsToDiv(divs_shippings);
});