<?php
class Customer extends CustomerCore
{
    public $company_name;
    public $cpf;
    public $rg;
    public $cnpj;
    public $ie;
    public $person_type;
    public $document_number;

    public function __construct($id = null) 
    {   
        if (file_exists(_PS_MODULE_DIR_ . 'agcustomers/agcustomers.php')) {
            require_once _PS_MODULE_DIR_ . 'agcustomers/agcustomers.php';
            $module = new AgCustomers;
            $fields = $module->getFields();
            foreach ($fields['customer'] as $field) {
                self::$definition['fields'][$field['name']] = ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'required' => false];
                @$this->{$field['name']} = '';
            }

            self::$definition['fields']['person_type'] = array('type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'required' => false, 'size' => 2);
            self::$definition['fields']['document_number'] = array('type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'required' => false, 'size' => 20);
        }

        parent::__construct($id);
    }
    

    public function getFields() {
        $add_field = parent::getFields();

        $add_field['person_type'] = $this->person_type;
        if (class_exists('agcustomers')) {
            $module = new agcustomers;
            $fields = $module->getFields();
            foreach ($fields['customer'] as $field) {
                $add_field[$field['name']] = pSQL($this->{$field['name']});
            }
        }
        $add_field['document_number'] = pSQL($this->document_number);

        return $add_field;
    }

    public function add($auto_date = true, $null_values = false)
    {
        if (Validate::isLoadedObject(Context::getContext()->employee) || Tools::getIsSet('fields_opc')) {
            if (file_exists(_PS_MODULE_DIR_ . 'agcustomers/agcustomers.php')) {
                require_once _PS_MODULE_DIR_ . 'agcustomers/agcustomers.php';
            }
            if (Tools::getIsSet('person_type')) {
                $this->person_type = Tools::getValue('person_type');
            }
            if (class_exists('agcustomers')) {
                $module = new agcustomers;
                $fields = $module->getFields();
                foreach ($fields['customer'] as $field) {                    
                    if (Tools::getIsSet($field['name'])) {
                        $this->{$field['name']} = Tools::getValue($field['name']);
                    }
                }
            }
        }
        if ($this->person_type == 'pj') {
            $this->document_number = $this->cnpj;
        } else {
            $this->document_number = $this->cpf;
        }
        return parent::add($auto_date, $null_values);
    }

    public function update($null_values = false)
    {
        if (Validate::isLoadedObject(Context::getContext()->employee) || Tools::getIsSet('fields_opc')) {
            if (Tools::getIsSet('person_type')) {
                $this->person_type = Tools::getValue('person_type');
            }
            if (class_exists('agcustomers')) {
                $module = new agcustomers;
                $fields = $module->getFields();
                foreach ($fields['customer'] as $field) {                    
                    if (Tools::getIsSet($field['name'])) {
                        $this->{$field['name']} = Tools::getValue($field['name']);
                    }
                }
            }
        }
        if ($this->person_type == 'pj') {
            $this->document_number = $this->cnpj;
        } else {
            $this->document_number = $this->cpf;
        }
        return parent::update($null_values);
    }
}
