<form class="form-horizontal" method="post" data-askreview="{$multishop_ask_review}">
	<ps-tabs position="top">
        <ps-tab label="{l s='Modules' mod='agcliente'}" active="true" id="tabModules" icon="icon-puzzle-piece" fa="cogs">
        	<table id="modules-list" class="table">
        		<tbody>
		        	{foreach from=$modules item=module}
		        		{if $module->is_authenticated}
		        			{assign var=class_name value="is-authenticated"}
		        		{else}
		        			{assign var=class_name value="is-not-authenticated"}		        		
		        		{/if}
		        		<tr data-name="{$module->module_name}" class="{$class_name}">
		        			<td class="fixed-width-xs">
		        				<img src="{$module->image_url}" />
		        			<td>
		        				<div>
		        					<div class="text-muted">
		        						{' > '|implode:$module->categories} 
		        					</div>
		        					<div class="module_name">
		        						{$module->product_name}
			        					<small class="text-muted">
			        						v{$module->last_version}
			        					</small>
			        				</div>

			        				<div class='reviews {if $module->is_reviewed}reviewed{/if} {if $module->installed}installed{/if}'
				        				{if $module->count_reviews}
				        					title="Avaliação: {$module->sum_reviews / $module->count_reviews} / 10"
				        				{else}
				        					title="Sem Avaliações"
				        				{/if}
				        			>
				        				{for $i=0 to 4}
				        					<span class="icon-star {if $module->count_reviews && $module->sum_reviews / $module->count_reviews > $i * 2}active{/if}"></span>
				        				{/for} ({$module->count_reviews})
				        			</div>
			        				<p class="module_description">
			        					{$module->short_description}
									</p>
		        				</div>
		        			<td class="fixed-width-xxl">
		        				<label for="license_{$module->module_name}">{l s='License' mod='agcliente'}</label>
		        				<input name="license_{$module->module_name}" id="license_{$module->module_name}" type="text" value="{AgModule::getLicenseKeyStatic($module->module_name)}" />
		        			<td class="actions">
		        				{if $is_main_shop}
				        			<div class="btn-group-action">
										<div class="btn-group pull-right">
											<a class="btn btn-default download_last_version"  href="{$download_link}&agdownload&module_name={$module->module_name}">
												<i class="icon-download"></i> {l s='Download last version' mod='agcliente'}
											</a>

											<button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
												<span class="caret">&nbsp;</span>
											</button>
											<ul class="dropdown-menu">
												{if $module->installed}
													<li><a href='{$download_link}&aguninstall&module_name={$module->module_name}' class="uninstall">Desinstalar</a></li>
												{else if !$module->in_shop}
													<li><a href='{$download_link}&agdownloadandinstall&module_name={$module->module_name}' class="download-and-install">Baixar e Instalar</a></li>
												{else}
													<li><a href='{$download_link}&aginstall&module_name={$module->module_name}' class="install">Instalar</a></li>
												{/if}


												{if $module->enabled}
													<li><a href='{$download_link}&agdisable&module_name={$module->module_name}' class="disable">Desativar</a></li>
												{else if !$module->enabled && $module->installed}
													<li><a href='{$download_link}&agenable&module_name={$module->module_name}' class="enable">Ativar</a></li>
												{/if}

												{if $module->installed && $module->configurable}
													<li><a href="{$link->getAdminLink('AdminModules')}&configure={$module->module_name}&module_name={$module->module_name}" class="disable">Configurar</a></li>
												{/if}
											</ul>
										</div>
									</div>
								{/if}
							</td>
						</div>
		        	{/foreach}
		        </tbody>
	        </table>
        </ps-tab>
        <ps-tab label="{l s='Configuração' mod='agcliente'}" active="false" id="tabConfiguration" icon="icon-cogs" fa="cogs">
        	{if !$is_main_shop}
        		<div class='alert alert-info'>Algumas configurações só podem ser modificadas pelo administrador da loja principal de seu PrestaShop.</div>
        	{/if}

        	{if $is_main_shop}
        		{include file=$modules_path|cat:"agcliente/views/templates/hook/includes/input_switch.tpl" label="Atualizar Módulos Automaticamente" value={$agcliente_autoupgrade_modules} name='AGCLIENTE_AUTOUPGRADE_MODULES'}
        	{/if}

        	<ps-panel-footer>
                <ps-panel-footer-submit direction="left" title="Cancelar" icon='process-icon-cancel'></ps-panel-footer-submit>
                <ps-panel-footer-submit direction="right" title="Salvar" icon='process-icon-save' name="agcliente_submit"></ps-panel-footer-submit>
            </ps-panel-footer>
        </ps-tab>
    </ps-tabs>
</form>
	{include file=$modules_path|cat:"agcliente/views/templates/hook/review_form.tpl"}

