$(function(){
	//corpo da tabela em que a simulação é exibida
	var tbody;
	var jqxhr;

	var is_quickview;

	function simulateCart()
	{
		if (jqxhr != null) {
			jqxhr.abort();
		}

		jqxhr = $.ajax({
			url : agti_url_simulate,
			data : {
				cart: true,
				postcode : $('#agti_shipping_simulation_postcode').val()
			},
			type : 'get',
			dataType : 'json',
			success : function(data){
				$('.agti_shipping_simulation').html(data.simulation);
				$('#agti_shipping_simulation_postcode').mask('00000-000');
			},
			error : function(){
				$('.agti_shipping_simulation button').removeAttr('disabled');
			}
		});
	}

	function simulateProduct()
	{
		if (jqxhr != null) {
			jqxhr.abort();
		}
		jqxhr = $.ajax({
			url : agti_url_simulate,
			data : $('#add-to-cart-or-refresh').serialize() + '&postcode=' + $('#agti_shipping_simulation_postcode').val() + '&id_product_attribute=' + $('.agti_shipping_simulation').attr('data-id-product-attribute'),
			type : 'get',
			dataType : 'json',
			success : function(data){
				var simulation = $(data.simulation);

				$('.agti_shipping_simulation').html(simulation.html());
				$('#agti_shipping_simulation_postcode').mask('00000-000');
			},
			error : function(){
				$('.agti_shipping_simulation button').removeAttr('disabled');
			}
		});
	}

	function simulate()
	{
		$('.agti_shipping_simulation button').attr('disabled', 'disabled');		

		//página do produto ou página de visualização rápida do produto
		if ($('body').is('#product') || is_quickview) {
			simulateProduct();
		} else if ($('body').is('#cart') || $('body').is('#order')) {
			//página do carrinho de compras

			//aguarda alguns instantes para que o carrinho de compras seja atualizado
			//antes de a simulação ser realizada
			simulateCart();			
		}
	}

	$(document).on('click', '.agti_shipping_simulation button, .product_quantity_down, .product_quantity_up', function(e){
		if ($(this).closest('.quickview').length > 0) {
			is_quickview = true;
		} else {
			is_quickview = false;
		}

		simulate();

		tbody = $('.agti_shipping_simulation table tbody');
		tbody.empty();

		e.stopPropagation();
		return false;
	});

	//botão de editar quantidade dos produtos na tela do carrinho de compras
	$(document).on('change', '.js-cart-line-product-quantity', function(){
		is_quickview = false;

		tbody = $('.agti_shipping_simulation table tbody');
		tbody.empty();

		$('.agti_shipping_simulation button').attr('disabled', 'disabled');

		setTimeout(simulateCart, 800);
	});

	//botão de remover produto na tela do carrinho de compras
	$(document).on('click', '.remove-from-cart', function(){
		is_quickview = false;

		tbody = $('.agti_shipping_simulation table tbody');
		tbody.empty();

		$('.agti_shipping_simulation button').attr('disabled', 'disabled');

		setTimeout(simulateCart, 800);
	});
})