$(function(){
    var form = $('.address-form form, #checkout-addresses-step form');
    var optional_divs = $(form.find('.form-control-comment'));
    var optional_div;

    //busca pelo div de "obrigatório" que de fato possua o texto "Campo Obrigatório"
    optional_div = $(
        optional_divs.filter(function(){
            return $(this).text().trim() != '';
        })[0]
    );

    function markRequiredFields()
    {
        $.each(agcustomers.fields.address, function(key, value){
            if (value.required == "1") {
                form
                    .find('[name=' + value.name + ']')
                    .prop('required', true)
                    .closest('.form-group')
                    .find('.form-control-comment')
                    .remove();
            } else {
                var input = form.find('[name=' + value.name + ']');

                input.prop('required', false)
                    .closest('.form-group')
                    .find('.form-control-comment')
                    .remove();

                input.closest('.form-group').append(optional_div.clone());
            }
        });
    }

    form.on('change', 'input,select,textarea', function(key, value) {
        markRequiredFields();
    });
    
    markRequiredFields();
});