$(function(){
	/******************************** envio das licenças **********************/
	{
		var jqxhr;

		function submitLicense(module_name, input)
		{
			return new Promise(function(resolve, reject){
				var url = 'index.php?controller=AdminModules&token=' + token + '&configure=agcliente&save_license&hash=' + $(input).val() + '&module_for_license=' + module_name;				
				jqxhr = $.ajax({
					url: url,
					dataType: 'JSON',
					success: function(data) {
						if (typeof data.success !== 'undefined' && data.success) {
							resolve();
						} else {
							if (typeof data.error !== 'undefined') {
								reject(new Error(data.error));
							} else {
								reject(new Error('Ocorreu um erro inexperado'));		
							}
						}
					},
					error: function() {
						reject(new Error('Ocorreu um erro inexperado'));
					}
				})
			});
		}

		$('#modules-list input[type=text]').on('input', function(){
			var that = $(this);

			if (typeof jqxhr !== 'undefined' && typeof jqxhr.abort !== 'undefined') {
				jqxhr.abort();
			}

			var ereg_licenses = /([0-9a-z]{5}-){4}[0-9a-z]{5}/gi;

			if (!ereg_licenses.test($(this).val())) {
				$(this).closest('tr').removeClass('is-authenticated').removeClass('is-not-authenticated');
				return;
			}

			submitLicense($(this).closest('tr').attr('data-name'), $(this))
			.then(function(){
				$(that).closest('tr').removeClass('is-not-authenticated').addClass('is-authenticated');
			})
			.catch(function(error){
				if (error !== '') {
					$.growl.error({message: error, title: ''});
				}

				$(that).closest('tr').removeClass('is-authenticated').addClass('is-not-authenticated');
			})
		});
	}


	/******************************** reviews *******************************/
	{
		//verifica se deve ser exibido o modal de review de algum dos módulos
		var url = location.href;
		var ereg = /review=([a-zA-z]*)/;
		var matches = ereg.exec(url);
		var ask_review = $('#modules-list').closest('form').attr('data-askreview') == '1';

		if (matches != null && matches.length == 2 && ask_review) {
			var tr = $('#modules-list tr').filter(function(){
				if ($(this).attr('data-name') == matches[1]) {
					return true;
				}
			});

			var reviews = tr.find('.reviews');
			if (reviews.is('.reviewed') || reviews.is('.installed') == false) {
				return;
			}

			openReviewModal(matches[1]);
		}

		function openReviewModal(module_name)
		{
			var tr = $('#modules-list tr').filter(function(){
				if ($(this).attr('data-name') == matches[1]) {
					return true;
				}
			});

			$('.review.panel strong').text($(tr).find('.module_name').text().trim());
			$('[name=review_module]').val(module_name);

			var modal = new AgModal({content: $('.review.panel').removeClass('hidden').closest('form')[0]});
			modal.open();
		}

		$('#modules-list .reviews').click(function(){
			if ($(this).is('.reviewed') || $(this).is('.installed') == false || !ask_review) {
				return;
			}

			openReviewModal($(this).closest('tr').attr('data-name'));
		});

		$('.review.panel button[type=submit]').click(function(){
			var data = new FormData(this.closest('form'));

			var url = location.href;
			url += '&send_review';

			var that = this;
			$(that).attr('disabled', true);

			$.ajax({
				url: url,
				data: data,
				type: 'POST',
				dataType: 'JSON',
				cache: false,
		        contentType: false,
		        processData: false,
			})
			.then(function(data){
				if (data.success) {
					$.growl.notice({
						title: '',
						message: 'Avaliação submetida com sucesso!'
					});
					setTimeout(window.location.reload.bind(window.location), 1000);
				} else {
					$.grol.error({
						title: '',
						message: data.error
					});
				}
			})
			.fail(function(data){
				$(that).removeAttr('disaled');
				$.growl.error({
					title: '',
					message: 'Ocorreu um erro inesperado.'
				});
			});
			return false;
		});
	}
});