<?php
class Customer extends CustomerCore
{
    /*
    * module: agcustomers
    * date: 2020-11-06 21:55:37
    * version: 2.2.15
    */
    public $company_name;
    /*
    * module: agcustomers
    * date: 2020-11-06 21:55:37
    * version: 2.2.15
    */
    public $cpf;
    /*
    * module: agcustomers
    * date: 2020-11-06 21:55:37
    * version: 2.2.15
    */
    public $rg;
    /*
    * module: agcustomers
    * date: 2020-11-06 21:55:37
    * version: 2.2.15
    */
    public $cnpj;
    /*
    * module: agcustomers
    * date: 2020-11-06 21:55:37
    * version: 2.2.15
    */
    public $ie;
    /*
    * module: agcustomers
    * date: 2020-11-06 21:55:37
    * version: 2.2.15
    */
    public $person_type;
    /*
    * module: agcustomers
    * date: 2020-11-06 21:55:37
    * version: 2.2.15
    */
    public $document_number;
    /*
    * module: agcustomers
    * date: 2020-11-06 21:55:37
    * version: 2.2.15
    */
    public function __construct($id = null) 
    {   
        if (file_exists(_PS_MODULE_DIR_ . 'agcustomers/agcustomers.php')) {
            require_once _PS_MODULE_DIR_ . 'agcustomers/agcustomers.php';
            $module = new AgCustomers;
            $fields = $module->getFields();
            foreach ($fields['customer'] as $field) {
                self::$definition['fields'][$field['name']] = ['type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'required' => false];
                @$this->{$field['name']} = '';
            }
            self::$definition['fields']['person_type'] = array('type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'required' => false, 'size' => 2);
            self::$definition['fields']['document_number'] = array('type' => self::TYPE_STRING, 'validate' => 'isGenericName', 'required' => false, 'size' => 20);
        }
        parent::__construct($id);
    }
    
    /*
    * module: agcustomers
    * date: 2020-11-06 21:55:37
    * version: 2.2.15
    */
    public function getFields() {
        $add_field = parent::getFields();
        $add_field['person_type'] = $this->person_type;
        if (class_exists('agcustomers')) {
            $module = new agcustomers;
            $fields = $module->getFields();
            foreach ($fields['customer'] as $field) {
                $add_field[$field['name']] = pSQL($this->{$field['name']});
            }
        }
        $add_field['document_number'] = pSQL($this->document_number);
        return $add_field;
    }
    /*
    * module: agcustomers
    * date: 2020-11-06 21:55:37
    * version: 2.2.15
    */
    public function add($auto_date = true, $null_values = false)
    {
        if (Validate::isLoadedObject(Context::getContext()->employee) || Tools::getIsSet('fields_opc')) {
            if (file_exists(_PS_MODULE_DIR_ . 'agcustomers/agcustomers.php')) {
                require_once _PS_MODULE_DIR_ . 'agcustomers/agcustomers.php';
            }
            if (Tools::getIsSet('person_type')) {
                $this->person_type = Tools::getValue('person_type');
            }
            if (class_exists('agcustomers')) {
                $module = new agcustomers;
                $fields = $module->getFields();
                foreach ($fields['customer'] as $field) {                    
                    if (Tools::getIsSet($field['name'])) {
                        $this->{$field['name']} = Tools::getValue($field['name']);
                    }
                }
            }
        }
        if ($this->person_type == 'pj') {
            $this->document_number = $this->cnpj;
        } else {
            $this->document_number = $this->cpf;
        }
        return parent::add($auto_date, $null_values);
    }
    /*
    * module: agcustomers
    * date: 2020-11-06 21:55:37
    * version: 2.2.15
    */
    public function update($null_values = false)
    {
        if (Validate::isLoadedObject(Context::getContext()->employee) || Tools::getIsSet('fields_opc')) {
            if (Tools::getIsSet('person_type')) {
                $this->person_type = Tools::getValue('person_type');
            }
            if (class_exists('agcustomers')) {
                $module = new agcustomers;
                $fields = $module->getFields();
                foreach ($fields['customer'] as $field) {                    
                    if (Tools::getIsSet($field['name'])) {
                        $this->{$field['name']} = Tools::getValue($field['name']);
                    }
                }
            }
        }
        if ($this->person_type == 'pj') {
            $this->document_number = $this->cnpj;
        } else {
            $this->document_number = $this->cpf;
        }
        return parent::update($null_values);
    }
}
