<?php
require_once _PS_MODULE_DIR_ . 'agcliente/lib/AgModule.php';
class BaseAgOrderDocument extends AgModule
{
    protected $hooks = [
        'displayBackOfficeHeader',
        'displayAdminOrderContentOrder',
        'displayAdminOrderTabOrder'
    ];

    public function __construct()
    {
        $this->name                   = 'agorderdocument';
        $this->version                = '1.0.0';
        $this->bootstrap              = true;
        $this->author                 = 'AGTI';
        $this->need_instance          = 1;
        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => '1.7.99');

        parent::__construct();

        $this->displayName = 'Upload de documentos do pedido';
        $this->description = 'Permite o upload de documentos no pedido para serem baixados pelo seu cliente.';
    }

    public function hookDisplayBackOfficeHeader()
    {
        /** @var AdminController */
        $controller = $this->context->controller;

        if (Tools::getValue('controller') == 'AdminOrders' && Tools::getIsSet('vieworder')) {            
            if (isset($_FILES['agorderdocument']['name'])) {
                for ($i=0; $i<Tools::getValue('qty_files'); $i++) {
                    $filename = $_FILES['agorderdocument']['name'][$i];
                    $target_filename = uniqid();
                    $target = _PS_MODULE_DIR_ . $this->name . "/files/{$target_filename}";

                    $obj = new AgOrderDocumentUploads;
                    $obj->id_order = Tools::getValue('id_order');
                    $obj->uniqid = $target_filename;
                    $obj->filename = $filename;
                    $obj->save();

                    if (!move_uploaded_file($_FILES['agorderdocument']['tmp_name'][$i], $target)) {
                        echo json_encode(['success' => false, 'error' => ['Erro movendo o arquivo enviado.']]);
                        exit();
                    } 
                }

                echo json_encode(['success' => true]);
                exit();
            } elseif (Tools::getIsset('agorderdocument_remove')) {
                $document = new AgOrderDocumentUploads(Tools::getValue('id_agorderdocuments_upload'));
                if (!$document->checkEmployeePermission($this->context->employee)) {
                    echo json_encode(['success' => false, 'error' => 'Voce não tem permissão sobre o arquivo selecionado.']);
                } else {
                    unlink(_PS_MODULE_DIR_ . $this->name . '/files/' . $document->uniqid);
                    $document->delete();
                    echo json_encode(['success' => true, 'error' => 'Voce não tem permissão sobre o arquivo selecionado.']);
                }

                exit();
            } elseif (Tools::getIsset('agorderdocument_download')) {
                $document = new AgOrderDocumentUploads(Tools::getValue('id_agorderdocuments_upload'));
                if (!$document->checkEmployeePermission($this->context->employee)) {
                    echo json_encode(['success' => false, 'error' => 'Voce não tem permissão sobre o arquivo selecionado.']);
                } else {
                    $document->qtt_downloads++;
                    $document->update();
                    

                    $file = _PS_MODULE_DIR_ . $this->name . '/files/' . $document->uniqid;

                    header('Content-Description: File Transfer');
                    header('Content-Disposition: attachment; filename='. $document->filename);
                    header('Content-Length: ' . filesize($file));

                    readfile($file);
                }

                exit();
            }

            $controller->addCss([
                $this->_path . 'views/css/vendor/loadingOverlay.css',
                $this->_path . 'views/css/admin/orders_view.css'
            ]);

            $controller->addJs([
                $this->_path . 'views/js/vendor/loadingOverlay.js',
                $this->_path . 'views/js/admin/orders_view.js'
            ]);
        }
    }

    public function hookDisplayAdminOrderTabOrder($params)
    {
        $order = $params['order'];
        $documents = AgOrderDocumentUploads::findByIdOrder($order->id);

        $this->context->smarty->assign(['qtt_documents' => count($documents)]);
        return $this->display(_PS_MODULE_DIR_ . $this->name, 'admin_tab_order.tpl');
    }

    public function hookDisplayAdminOrderContentOrder($params)
    {
        $order = $params['order'];
        $documents = AgOrderDocumentUploads::findByIdOrder($order->id);

        foreach ($documents as $i=>$document) {
            $documents[$i]['link'] = $this->context->link->getAdminLink('AdminOrders', true, '', ['vieworder' => true, 'id_order' => $document['id_order'], 'agorderdocument_download' => true, 'id_agorderdocuments_upload' => $document['id_agorderdocuments_upload']]);
        }
        $this->context->smarty->assign(['documents_list' => $documents]);

        return $this->display(_PS_MODULE_DIR_ . $this->name, 'admin_order_content.tpl');
    }
}