<?php

require_once _PS_MODULE_DIR_ . 'agcliente/lib/AgModule.php';

class BaseAgWpButton extends AgModule
{
    protected $hooks = array(
        'displayHeader',
        'displayBackOfficeHeader',
        'displayFooter'
    );


    protected $main_tab = 'AdminParentModulesSf';
    protected $tabs = array(
        array(
            "name"      => "Endereços do WhatsApp",
            "className" => "AdminAgWpButtonAddress",
            "active"    => 0,
        )
    );

    public function __construct()
    {
        $this->name     = 'agwpbutton';
        $this->tab      = 'others';
        $this->version  = '1.0.6';
        $this->author   = 'AGTI';

        $this->bootstrap = true;
            
        parent::__construct();

        $this->displayName = $this->l('WhatsApp Chat', 'base');
        $this->description = $this->l('Let your customers to chat with you using WhatsApp.', 'base');

        if (!Configuration::get('WPBUTTON_NUMBER')) {
            $this->warnings[] = $this->l('You WhatsApp number is not configured', 'base');
        }
    }

    public function install()
    {
        Configuration::updateValue('WPBUTTON_DISTANCE_BOTTOM', '30');
        Configuration::updateValue('WPBUTTON_DISTANCE_SIDE', '30');
        Configuration::updateValue('WPBUTTON_SCREEN_SIDE', 'right');

        return parent::install();    
    }

    public function getContent()
    {
        $helper = new HelperForm;

        $fields_form[0]['form'] = array();
        $fields_form[0]['form']['legend'] = array('title' => 'Configuração');
        
        if (Tools::isSubmit('agwpbutton_config')) {
            Configuration::updateValue('WPBUTTON_NUMBER', Tools::getValue('WPBUTTON_NUMBER'));
            Configuration::updateValue('WPBUTTON_DISTANCE_BOTTOM', Tools::getValue('WPBUTTON_DISTANCE_BOTTOM'));
            Configuration::updateValue('WPBUTTON_DISTANCE_SIDE', Tools::getValue('WPBUTTON_DISTANCE_SIDE'));
            Configuration::updateValue('WPBUTTON_SCREEN_SIDE', Tools::getValue('WPBUTTON_SCREEN_SIDE'));

            Configuration::updateValue('WPBUTTON_DISPLAY_BACKOFFICE', Tools::getValue('WPBUTTON_DISPLAY_BACKOFFICE'));
            $fields_form[0]['form']['success'] = $this->l('WhatsApp number saved with success!', 'base');
        }

        $fields_form[0]['form']['input'] = array(
            array(
                'type' => 'text',
                'name' => 'WPBUTTON_NUMBER',
                'label' => 'Número de Telefone (completo)',
                'col' => 2
            ),
            array(
                'type' => 'radio',
                'name' => 'WPBUTTON_SCREEN_SIDE',
                'label' => 'Alinhar a:',
                'values' => [
                    [
                        'value' => 'left',
                        'label' => 'Esquerda',
                        'id' => 'agwpbutton_screen_side_left'
                    ],
                    [
                        'value' => 'right',
                        'label' => 'Direita',
                        'id' => 'agwpbutton_screen_side_right'
                    ]
                ]
            ),
            array(
                'type' => 'text',
                'name' => 'WPBUTTON_DISTANCE_SIDE',
                'label' => 'Distância da Lateral',
                'suffix' => 'px',
                'col' => 1
            ),
            array(
                'type' => 'text',
                'name' => 'WPBUTTON_DISTANCE_BOTTOM',
                'label' => 'Distância do rodapé',
                'suffix' => 'px',
                'col' => 1
            ),
            array(
                'type' => 'switch',
                'name' => 'WPBUTTON_DISPLAY_BACKOFFICE',
                'id'   => 'WPBUTTON_DISPLAY_BACKOFFICE',
                'label' => 'Exibir Ícone Flutuate no BackOffice',
                'values' => array(
                    array(
                        'id'    => 'WPBUTTON_DISPLAY_BACKOFFICE_on',
                        'value' => 1,
                        'label' => 'Sim',
                    ),
                    array(
                        'id'    => 'WPBUTTON_DISPLAY_BACKOFFICE_off',
                        'value' => 0,
                        'label' => 'Não',
                    ),
                ),
            )
        );

        
        $fields_form[0]['form']['submit'] = array(
            'title' => "Salvar",
            "name"  => "agwpbutton_config",
        );

        $helper->fields_value['WPBUTTON_NUMBER'] = Configuration::get('WPBUTTON_NUMBER');
        $helper->fields_value['WPBUTTON_DISTANCE_BOTTOM'] = Configuration::get('WPBUTTON_DISTANCE_BOTTOM');
        $helper->fields_value['WPBUTTON_DISTANCE_SIDE'] = Configuration::get('WPBUTTON_DISTANCE_SIDE');
        $helper->fields_value['WPBUTTON_SCREEN_SIDE'] = Configuration::get('WPBUTTON_SCREEN_SIDE');

        $helper->fields_value['WPBUTTON_DISPLAY_BACKOFFICE'] = Configuration::get('WPBUTTON_DISPLAY_BACKOFFICE');
        
        return $helper->generateForm($fields_form);
    }

    /************************** HOOKS *********************/
    public function hookHeader()
    {
        if (!Module::isEnabled($this->name) || !$this->auth()) {
            return;
        }

        Media::addJsDef([
            $this->name => [
                'urls' => [
                    'button' => $this->context->link->getModuleLink($this->name, 'button')
                ]
            ]
        ]);

        $this->context->controller->addCss($this->_path . 'views/css/' . $this->name . '.css');

        $this->context->controller->addJs($this->_path . 'views/js/' . $this->name . '.js');
    }

    public function hookFooter()
    {
        if (!Module::isEnabled($this->name) || !$this->auth()) {
            return;
        }

        return $this->displayButton();
    }

    public function displayButton()
    {
        if (!Configuration::get('WPBUTTON_NUMBER')) {
            return;
        }

        $img_path = $this->_path . 'views/img/whatsapp.png';
        $img_url = Tools::getCurrentUrlProtocolPrefix() . Tools::getMediaServer($img_path) . $img_path;

        $img_hover_path = $this->_path . 'views/img/whatsapp_hover.png';
        $img_hover_url = Tools::getCurrentUrlProtocolPrefix() . Tools::getMediaServer($img_hover_path) . $img_hover_path;

        $this->context->smarty->assign([
            'wp_img_url' => $img_url,
            'wp_img_hover_url' => $img_hover_url,
            'phone' => Configuration::get('WPBUTTON_NUMBER'),

            'side' => Configuration::get('WPBUTTON_SCREEN_SIDE'),
            'distance_bottom' => Configuration::get('WPBUTTON_DISTANCE_BOTTOM'),
            'distance_side' =>Configuration::get('WPBUTTON_DISTANCE_SIDE'),
        ]);

        return $this->display($this->_path, 'footer.tpl');
    }

    public function hookDisplayBackOfficeHeader()
    {
        /** @var AdminController */
        $controller = $this->context->controller;
        $html = '';

        if (version_compare(_PS_VERSION_, '1.7.7', '>=')) {
            if (!isset($this->context->controller->php_self) || $this->context->controller->php_self != 'AdminOrders') {
            } else {
                $controller->addJs($this->_path . 'views/js/admin_orders.1.7.7.js');
                $controller->addCss($this->_path . 'views/css/admin_orders.css');
            }
        } else {
            if ($controller->controller_name == 'AdminOrders' && Tools::getIsSet('vieworder')) {
                $controller->addJs($this->_path . 'views/js/admin_orders.js');
                $controller->addCss($this->_path . 'views/css/admin_orders.css');

                $html .= "<script type='text/javascript'>var agwpbutton_address_token = '" . Tools::getAdminTokenLite('AdminAgWpButtonAddress') . "';</script>";
                $html .= "<script type='text/javascript'>var agwpbutton_base_url = '" . $this->context->shop->getBaseURL() . "';</script>";
                $controller->addCss($this->_path . 'views/css/admin_orders.css');
            }
        }
        
        if (Configuration::get('WPBUTTON_DISPLAY_BACKOFFICE')) {
            $controller->addJs($this->_path . 'views/js/bo.js');
            $controller->addCss($this->_path . 'views/css/bo.css');            
            $html .= "<script type='text/javascript'>var agwpbutton_urls_button = '" . $this->context->link->getModuleLink($this->name, 'button') . "';</script>";
            $html .= "<script type='text/javascript'>var agwpbutton_insert_button = 1;</script>";
        }

        return $html;
    }
}