$(function(){
	var is_onepagecheckout = $('#onepagecheckoutps').length === 1;

	var validate_functions = {
		validateCpf: function(cpf)
		{
		    // Removing special characters from value
		    var value = cpf.replace( /([~!@#$%^&*()_+=`{}\[\]\-|\\:;'<>,.\/? ])+/g, "" );

		    // Checking value to have 11 digits only
		    if ( value.length !== 11 ) {
		        return false;
		    }

		    var sum = 0,
		        firstCN, secondCN, checkResult, i;

		    firstCN = parseInt( value.substring( 9, 10 ), 10 );
		    secondCN = parseInt( value.substring( 10, 11 ), 10 );

		    checkResult = function( sum, cn ) {
		        var result = ( sum * 10 ) % 11;
		        if ( ( result === 10 ) || ( result === 11 ) ) {
		            result = 0;
		        }
		        return ( result === cn );
		    };

		    // Checking for dump data
		    if ( value === "" ||
		        value === "00000000000" ||
		        value === "11111111111" ||
		        value === "22222222222" ||
		        value === "33333333333" ||
		        value === "44444444444" ||
		        value === "55555555555" ||
		        value === "66666666666" ||
		        value === "77777777777" ||
		        value === "88888888888" ||
		        value === "99999999999"
		    ) {
		        return false;
		    }

		    // Step 1 - using first Check Number:
		    for ( i = 1; i <= 9; i++ ) {
		        sum = sum + parseInt( value.substring( i - 1, i ), 10 ) * ( 11 - i );
		    }

		    // If first Check Number (CN) is valid, move to Step 2 - using second Check Number:
		    if ( checkResult( sum, firstCN ) ) {
		        sum = 0;
		        for ( i = 1; i <= 10; i++ ) {
		            sum = sum + parseInt( value.substring( i - 1, i ), 10 ) * ( 12 - i );
		        }
		        return checkResult( sum, secondCN );
		    }
		    return false;
		},
		validateCnpj: function(cnpj)
		{
		    //extrai os algarismos do CNPJ
		    var digits = [];
		    var length = cnpj.length;

		    for (var i=0; i<length; i++) {
		        if (parseInt(cnpj[i]) == cnpj[i]) {
		            digits.push(cnpj[i]);
		        }
		    }
		    
		    if (digits.length != 14) {
		        return false;
		    }

		    var factors = [5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2];

		    //verifica o primeiro dígito
		    var sum = 0;
		    for (var i=0; i<12; i++) {
		        sum += parseInt(digits[i]) * factors[i];
		    }

		    first_digit = 0;
		    mod = sum % 11;

		    if (mod>= 2) {
		        first_digit = 11 - mod;
		    }
		    
		    if (digits[12] != first_digit) {
		        return false;
		    }

		    factors = [6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2];

		    //verifica o segundo dígito
		    sum = 0;
		    for (var i=0; i<13; i++) {
		        sum += parseInt(digits[i]) * factors[i];
		    }

		    second_digit = 0;
		    mod = sum % 11;

		    if (mod>= 2) {
		        second_digit = 11 - mod;
		    }

		    if (digits[13] != second_digit) {
		        return false;
		    }

		    return true;
		}
	};

	function getLangData(array_datas, id_lang)
    {
        if (typeof array_datas !== 'object') {
            return array_datas;
        }

        if (typeof array_datas[id_lang] !== 'undefined') {
            return array_datas[id_lang];
        }

        return array_datas['id_lang'];
    }

	function getTypePerson()
	{
		var type_person_input = $('[name=person_type]'),
    		type_person;

    	if (type_person_input.length != 1) {
			type_person_input = type_person_input.filter(':checked');
			type_person = type_person_input.val();
    	} else {
    		type_person = type_person_input.val();
    	}

    	return type_person;
	}

	function markInputAsInvalid(input, error_msg)
	{
		if (!is_onepagecheckout) {
			input.closest('.form-group')
                .addClass('has-error').addClass('form-error')
                .removeClass('has-success').removeClass('form-success');
			input.removeClass('valid');
			
			if (typeof error_msg === 'undefined' || error_msg == "") {
				error_msg = input.closest('.form-group').find('label').text().trim() + " inválido.";
			}

			if (error_msg != "") {
				var div_error = $('<div/>', {
					class: 'col-md-6 agcustomers-error',
					text: error_msg
				});

				$(input).closest('.form-group').append(div_error);
			}
		} else {
			input.addClass('error')
            	.closest('.form-group')
                .addClass('has-error')
                .removeClass('has-success');

			input.removeClass('valid');
		}
	}

	function markInputAsValid(input)
	{
		if (!is_onepagecheckout)  {
			$(input).closest('.form-group').removeClass('has-error').removeClass('form-error').find('.agcustomers-error').remove();;
		} else {
			$(input).closest('.form-group').removeClass('has-error').find('.agcustomers-error').remove();
			input.removeClass('error');
		}
	}

	function validateInput(input, check_duplicate = false)
    {
		$return = new Promise(function(resolve, reject){
			markInputAsValid(input);
			var value = $(input).val();

			if (value == '' || typeof value === 'undefined') {
				if (input.is('[required]')) {
					markInputAsInvalid(input);
				}

				reject();
				return;
			}
			
			if (
				($(input).attr('name') == 'cnpj' && !validate_functions.validateCnpj(value))
				|| ($(input).attr('name') == 'cpf' && !validate_functions.validateCpf(value))
			) {
				markInputAsInvalid(input);
			}

			if (check_duplicate) {
				//verifica se este campo possui regra de unicidade

				$.each(agcustomers.fields.customer, function(key, value){
					if (value.name != input.prop('name')) {
						return;
					}
					
					//campo não é obrigatório
					if (typeof value.unique === 'undefined' || value.unique === "0") {
						check_duplicate = false;
					}
				})
			}
		
			if (!check_duplicate) {
				resolve();
				return;
			}

			checkInputDuplicity(input)
			.then(resolve)
			.catch(reject);
		});

		return $return;
	}
	
	function checkInputDuplicity(input)
	{
		return new Promise(function(resolve, reject){
			$.ajax({
				url: agcustomers.urls.ajaxRequests,
				type: 'GET',
				dataType: 'JSON',
				data: {
					action: 'checkDuplicity',
					field_name: input.prop('name'),
					value: input.val()
				}
			}).then(function(data){
				if (data.success && !data.duplicated) {
					resolve();
				} else {
					markInputAsInvalid(input, input.closest('.form-group').find('label').text().trim() + " já cadastrado.");
					reject(input.closest('.form-group').find('label').text().trim() + " já cadastrado.");
				}
			})
			.fail(reject);
		});
	}

    function validateInputs(check_duplicates = false)
    {
		let promises = [];

        $.each(agcustomers.fields.customer, function(key, value){
			var input = $('[name=' + value.name + ']');
			if (input.is(':visible')) {
				promises.push(validateInput(input, check_duplicates));
			}
        });

		var overlay = loadingOverlay().activate();
		
		return Promise.all(promises)
		.finally(function(){
			loadingOverlay().cancel(overlay);
			if ($('input.error').length > 0) {
				$('#btn_save_customer, #btn_place_order').attr('disabled', true).attr('title', 'Corrija o seu cadastro para continuar');
			} else {
				$('#btn_save_customer, #btn_place_order').removeAttr('disabled').removeAttr('title');
			}
		});
    }

    function addValidations()
    {
        setInterval(function(){
			$.each(agcustomers.fields.customer, function(key, value){
				var input = $('[name=' + value.name + ']');
				if (input.is(':visible') && !input.data('validation_event_added')) {
					var overlay = loadingOverlay().activate();
					validateInput(input, true)
					.finally(function(){
						loadingOverlay().cancel(overlay);
					})

					input.on('input', '', function(){
						validateInput(input, false);
					});

					var interval;
					input.on('keyup', '', function(){
						clearInterval(interval);
						interval = setTimeout(function(){
							var overlay2 = loadingOverlay().activate();
						
							validateInput(input, true)
							.finally(function(){
								loadingOverlay().cancel(overlay2);
							})
						}, 500);
					});

					input.data('validation_event_added', true);
				}
			});
        }, 100);

	    $('#customer-form').submit(function(){
			var error = false;
			$.each(agcustomers.fields.customer, function(key, value){
				if ($('[name=' + value.name + ']').closest('.form-group').is('.has-error')) {
					error = true;
					// return false;
				}
			});

			return !error;
	    });
	}


	function addMasks()
	{
		$.each(agcustomers.fields.customer, function(key, value){
			if (typeof value.mask !== 'undefined' && value.mask != '')
			$('[name=' + value.name + ']').mask(value.mask);
		});

		$('[name=birthday]').mask(agcustomers_mask_birthday_format.replace('Y', '0000').replace('m', '00').replace('d', '00'));

		maskPostcode();
		maskPhones();
		$(document).on('change', '[name=id_country], #delivery_id_country', function(){
			maskPostcode();
			maskPhones();
			setTimeout(function(){
				$('[name=number]').closest('.form-group').find('label').text(agcustomers_number_translation);
				$('[name=number]').attr('max-length', 10);
			}, 1500);
		});
	}

	function maskPostcode()
	{
		if ($('[name=id_country], #delivery_id_country').length == 0) {
			return;
		}
		
		var overlay = loadingOverlay().activate();

        //busca a máscara de CEP do país atual
        $.ajax({
            url: agcustomers.urls.ajaxRequests,
            dataType : 'JSON',
            data: {
                id_country: $('[name=id_country], #delivery_id_country').val(),
                action: 'getMasks'
            }
        })
        .done(function(data){
            if (data.success) {
                $('#postcode, #delivery_postcode, [name=postcode]').mask(data.masks.zipcode.replace(/N/g, '0').replace(/L/g, 'S'));
            }
        })
        .complete(function(){
            loadingOverlay().cancel(overlay);
        });
	}

	function maskPhones()
	{
		//máscara de telefone
        //http://www.igorescobar.com/blog/2012/07/29/mascara-javascript-para-os-novos-telefones-de-sao-paulo/
        var maskBehavior = function (val) {
            var input_country = $('[name=id_country], #id_country');
            var country_name = input_country.find('option:selected').text();

            if (country_name != 'Brazil' && country_name != 'Brasil') {
                return '+9999999999999999';
            }

            return val.replace(/\D/g, '').length === 11 ? '(00) 00000-0000' : '(00) 0000-00009';
        }

        options = {onKeyPress: function(val, e, field, options) {
            field.mask(maskBehavior.apply({}, arguments), options);
        }};

        $('#phone_mobile, #delivery_phone_mobile, [name=phone_mobile], #phone, #delivery_phone, [name=phone]').mask(maskBehavior, options);
	}

	function positionFields()
	{
		$.each(agcustomers.fields.customer.reverse(), function(key, value){
			var input_birthday = $('[name=birthday]');
			$('[name=' + value.name + ']').closest('.form-group').insertAfter(input_birthday.closest('.form-group'));
		});

		$('[name=person_type]').closest('.form-group').insertBefore($('[name=firstname]').closest('section'));
	}

	function handleFieldVisibility()
    {
    	var type_person = getTypePerson();

        $.each(agcustomers.fields.customer, function(key, value){
            if (typeof value.insert !== 'undefined' && typeof value.insert[type_person] !== 'undefined' && value.insert[type_person] == 1) {
                $('[name=' + value.name + ']').closest('.form-group').show();
            } else {
                $('[name=' + value.name + ']').closest('.form-group').hide();
            }
        });
    }

    function handleRequiredFields()
    {
        var type_person = getTypePerson();

        $.each(agcustomers.fields.customer, function(key, value){
            var input = $('[name=' + value.name + ']');
            var label = $(input).siblings('label');

            if (typeof value.required !== 'undefined' && typeof value.required[type_person] !== 'undefined' && value.required[type_person] == 1) {
                input.attr('required', true);
                input.closest('.form-group').addClass('required');

                $(input).closest('.form-group').find('.form-control-comment').hide();
            } else {
                input.removeAttr('required');
                input.closest('.form-group').removeClass('required');
                $(input).closest('.form-group').find('.form-control-comment').show();
            }
        });
    }

    function addEvents()
    {
    	$('[name=person_type]').change(function(){
            handleFieldVisibility();
            handleRequiredFields();
            return true;
        });
    }

    function addInputsOnepagecheckout()
    {
    	var row = $('<div/>', {
    		class: 'row row_type_person'
    	});
    	row.insertAfter($("[name=id_gender]").closest('.row'));

    	var label = $('<label/>', {
    		text: agcustomers.translations.type_person
    	}).appendTo(row);

    	$.each(agcustomers.type_persons, function(key, type_person){
    		if (type_person.active == 0) {
    			return;
    		}
    		var div = $('<div/>', {}).appendTo(row);
    		var label = $('<label/>', {for: 'person_type_' + type_person.name, text: getLangData(type_person.label, agcustomers.id_lang)}).appendTo(div);
    		var input = $('<input/>', {
    			type: 'radio',
    			name: 'person_type',
    			value: type_person.name,
    			id: 'person_type_' + type_person.name
    		}).prependTo(label);


    		if (agcustomers.customer_data.person_type == type_person.name) {
    			input.attr('checked', true);
    		}
    	})

    	row = $('<div/>', {
    		class: 'row'
    	});
    	row.insertBefore($('#field_customer_newsletter').closest('.row'));

    	$.each(agcustomers.fields.customer, function(key, field) {
    		if (row.find('>div').length == 2) {
    			row = $('<div/>', {
		    		class: 'row'
		    	});
		    	row.insertBefore($('#field_customer_newsletter').closest('.row'));
    		}

    		var div = $('<div/>', {
    			class: 'form-group col-xs-6 col-6 required'
    		});
    		div.appendTo(row);

    		var label = $('<label/>', {
    			text: getLangData(field.label, agcustomers.id_lang) + ': ',
    			for: 'customer.' + field.name
    		});

    		label.appendTo(div);

    		var input = $('<input/>', {
    			type: 'text',
    			name: field.name,
    			id: 'customer.' + field.name,
    			class: 'form-control'
    		});
    		input.appendTo(div);


    		input.val(agcustomers.customer_data[field.name]);
    		
    	});
    }

	function init()
	{
		if (is_onepagecheckout) {
			if ($('[name=person_type]').length == 0) {
				addInputsOnepagecheckout();
			} else {
				$('[name=person_type]').closest('.row').insertAfter($('#form_customer > .row')[0]);
			}
		}


    	//se só houver um tipo de pessoa, já o seleciona
    	if ($('[name=person_type]').length < 2) {
    		$('[name=person_type]').attr('checked', true);
    		$('[name=person_type]').closest('.row').hide();
    	}


		//enquanto as regras de validação não são configuráveis, insere elas manualmente
		$('input[name=cpf]')
			.attr('data-validate-function', 'validateCpf')
			.attr('data-db-table', 'customer');

		//enquanto as regras de validação não são configuráveis, insere elas manualmente
		$('input[name=cnpj]')
			.attr('data-validate-function', 'validateCnpj')
			.attr('data-db-table', 'customer');

		if (agcustomers.type_persons.length == 1) {
            $('[name=person_type]').val(agcustomers.type_persons[0].name);
        }

		$('[name=number]').closest('.form-group').find('label').text(agcustomers_number_translation);
		$('[name=number]').attr('maxlength', 10);


		addValidations();
		addMasks();
		positionFields();
		addEvents();

		handleFieldVisibility();
		handleRequiredFields();
	}

	init();
});