<?php
require_once _PS_MODULE_DIR_ . 'agcliente/lib/AgModule.php';
require_once _PS_MODULE_DIR_ . 'agcustomers/vendor/facebook/graph-sdk/src/Facebook/autoload.php';

class BaseAgCustomers extends AgModule
{
    protected $hooks = array(
        'displayHeader',
        'displayBackOfficeHeader',
        'displayAdminOrderContentOrder',
        'additionalCustomerFormFields',
        'actionAdminCustomersFormModifier',
        'additionalCustomerAddressFormFields',
        'actionAdminAddressesFormModifier',
        'actionObjectCustomerAddAfter',
        'actionObjectCustomerUpdateAfter',
    );

    protected $tabs = [
        [
            'name' => 'Módulo de Cadastro AGTI',
            'className' => 'AdminAgCustomersLoadOptions',
            'active' => 0
        ]
    ];

    public function __construct()
    {
        $this->name     = 'agcustomers';
        $this->tab      = 'Others';
        $this->version  = '2.2.15';
        $this->author   = 'AGTI';

        $this->bootstrap = true;
        
        parent::__construct();

        $this->displayName = $this->l('Social Login/Registration', 'base');
        $this->description = $this->l('Allows your customers to register and login to your store through Facebook.', 'base');

        $this->loadMappings();
    }

    public function install()
    {
        //cria a coluna de número na tabela de endereços
        $sql = 'ALTER TABLE ' . _DB_PREFIX_ . 'address add column number varchar(20)';
        try {
            Db::getInstance()->execute($sql);
        } catch (Exception $e) {
        }      
        
        $sql = 'ALTER TABLE ' . _DB_PREFIX_ . 'customer add column cpf varchar(20)';
        try {
            Db::getInstance()->execute($sql);
        } catch (Exception $e) {
        }

        $sql = 'ALTER TABLE ' . _DB_PREFIX_ . 'customer add column cnpj varchar(30)';
        try {
            Db::getInstance()->execute($sql);
        } catch (Exception $e) {
        }

        $sql = 'ALTER TABLE ' . _DB_PREFIX_ . 'customer add column rg varchar(20)';
        try {
            Db::getInstance()->execute($sql);
        } catch (Exception $e) {
        }

        $sql = 'ALTER TABLE ' . _DB_PREFIX_ . 'customer add column ie varchar(20)';
        try {
            Db::getInstance()->execute($sql);
        } catch (Exception $e) {
        }

        $sql = 'ALTER TABLE ' . _DB_PREFIX_ . 'customer add column company_name varchar(100)';
        try {
            Db::getInstance()->execute($sql);
        } catch (Exception $e) {
        }

        $sql = 'ALTER TABLE ' . _DB_PREFIX_ . 'customer add column person_type varchar(2)';
        try {
            Db::getInstance()->execute($sql);
        } catch (Exception $e) {
        }

        $sql = 'ALTER TABLE ' . _DB_PREFIX_ . 'customer add column document_number varchar(20)';
        try {
            Db::getInstance()->execute($sql);
        } catch (Exception $e) {
        }

        if (!Configuration::hasKey('AGTI_CEP_PROVIDER')) {
            Configuration::updateValue('AGTI_CEP_PROVIDER', 'republica_do_cep');
        }
        $this->resetConfig();
        return parent::install();
    }

    public function reset()
    {
        $this->resetConfig();
    }

    public function resetConfig()
    {
        if (!Configuration::hasKey('AGCUSTOMERS_CONFIG')) {
            Configuration::updateValue('AGCUSTOMERS_CONFIG', serialize($this->getDefaultOptions()));
        }

        $brazil_id = Country::getByIso('BR');
        $tmp_addr_format = new AddressFormat($brazil_id);
        $tmp_addr_format->format = '
firstname lastname
Country:name
postcode
address1, number
address2
city-State:iso_code
phone
phone_mobile';
        $tmp_addr_format->id_country = $brazil_id;
        $tmp_addr_format->save();
    }

    public function getContent()
    {
        $options = $this->getOptions();
        Configuration::updateValue('AGCUSTOMERS_CONFIG', serialize($options));

        if (Tools::getIsSet('resetFields')) {
            Configuration::updateValue('AGCUSTOMERS_CONFIG', serialize($this->getDefaultOptions()));
            
            echo Tools::jsonEncode([
                'success' => true,
            ]);
            exit();
        } elseif (Tools::getIsSet('resetOverrides')) {
            $this->uninstallOverrides();
            $this->installOverrides();
            
            echo Tools::jsonEncode([
                'success' => true,
            ]);
            exit();
        }
        $this->context->controller->addJs([
            $this->_path . '/views/js/loadingOverlay.js',
            $this->_path . '/views/js/config.js'
        ]);

        if (Tools::isSubmit('agcustomers-submit')) {
            $app_id = Tools::getValue('agcustomers_facebook_app_id');
            $app_secret = Tools::getValue('agcustomers_facebook_app_secret');
            $og_version = Tools::getValue('agcustomers_facebook_og_version');

            Configuration::updateValue('AGCUSTOMERS_FACEBOOK_APP_ID', $app_id);
            Configuration::updateValue('AGCUSTOMERS_FACEBOOK_SECRET_KEY', $app_secret);
            Configuration::updateValue('AGCUSTOMERS_FACEBOOK_OG_VERSION', $og_version);

            Configuration::updateValue('AGCUSTOMERS_INSERT_CUSTOMER_FIELDS', Tools::getValue('insert_customer_fields'));
            Configuration::updateValue('AGCUSTOMERS_INSERT_RG_FIELD', Tools::getValue('insert_rg_field'));
            Configuration::updateValue('AGCUSTOMERS_INSERT_COMPANY_FIELDS', Tools::getValue('insert_company_fields'));
            Configuration::updateValue('AGCUSTOMERS_INSERT_NUMBER_FIELD', Tools::getValue('insert_number_field'));
            Configuration::updateValue('AGCUSTOMERS_REQUIRE_NUMBER_FIELD', Tools::getValue('require_number_field'));
            Configuration::updateValue('AGCUSTOMERS_FORCE_B2B_FIELDS', Tools::getValue('force_b2b_fields'));
            $this->getDistrictMapping()->mapsTo(Tools::getValue('agcustomers_district'));

            //isso é necessário para que os campos do caadstro de cliente sejam mantidos em ordem quando novos campos são inseridos
            $config = $_POST['AGCUSTOMERS_CONFIG'];
            $customer = $config['fields']['customer'];
            ksort($customer);

            //valida os dados enviados quanto à unicidade do nome
            $names = [];
            $errors = false;

            foreach ($customer as $input) {
                if (isset($names[$input['name']])) {
                    $this->context->controller->errors[] = "Campo " . $input['name'] . " duplicado!";
                    $errors = true;
                    continue;
                }

                if (preg_match("/^[a-zA-Z_][a-zA-Z0-9_]*$/", $input['name']) !== 1) {
                    $this->context->controller->errors[] = "Nome da coluna " . $input['name'] . " inválido. Utilize apenas letras e números!";
                    $errors = true;
                    continue;   
                }
            }

            if ($errors) {
                goto render_form;
            }
     
            $config['fields']['customer'] = $customer;

            Configuration::updateValue('AGCUSTOMERS_CONFIG', serialize($config));
            $this->createCustomerColumns($customer);
            $this->context->controller->confirmations[] = 'Configurações salvas com sucesso!';

            Configuration::updateValue('AGTI_CEP_PROVIDER', Tools::getValue('agti_cep_provider'));
        }

        render_form:
        $config = $this->getOptions();
        $languages = Language::getLanguages(false);

        agcliente::prepareConfigHelpTab($this->name);
        
        $this->context->smarty->assign(array(
            'form_action' => $this->context->link->getAdminLink('AdminModules') . '&configure=' . $this->name,
            'facebook_app_id' => Configuration::get('AGCUSTOMERS_FACEBOOK_APP_ID'),
            'facebook_app_secret' => Configuration::get('AGCUSTOMERS_FACEBOOK_SECRET_KEY'),
            'facebook_og_version' => Configuration::get('AGCUSTOMERS_FACEBOOK_OG_VERSION'),
            'module' => $this,
            'authenticated' => $this->auth(),

            // 'force_b2b_fields' => Configuration::get('AGCUSTOMERS_FORCE_B2B_FIELDS'),

            // 'insert_customer_fields' => Configuration::get('AGCUSTOMERS_INSERT_CUSTOMER_FIELDS'),
            // 'insert_rg_field' => Configuration::get('AGCUSTOMERS_INSERT_RG_FIELD'),
            // 'insert_company_fields' => Configuration::get('AGCUSTOMERS_INSERT_COMPANY_FIELDS'),
            // 'insert_number_field' => Configuration::get('AGCUSTOMERS_INSERT_NUMBER_FIELD'),
            // 'require_number_field' => Configuration::get('AGCUSTOMERS_REQUIRE_NUMBER_FIELD'),

            'link_import_fkcustomers' => $this->context->link->getModuleLink($this->name, 'importFromFkCustomers'),
            'link_import_djtal' => $this->context->link->getModuleLink($this->name, 'importFromDjtal'),

            'config' => $config,
            'languages' => $languages,
            'modules_path' => _PS_MODULE_DIR_,

            'agti_cep_provider' => Configuration::get('AGTI_CEP_PROVIDER'),
            'ps17' => $this->ps17
        ));

        $redirectLinks = [
            Context::getContext()->link->getModuleLink('agcustomers', 'fbRedirect', ['back' => 'authentication']),
            Context::getContext()->link->getModuleLink('agcustomers', 'fbRedirect', ['back' => 'order']),
            Context::getContext()->link->getModuleLink('agcustomers', 'fbRedirect', ['back' => 'cart']),
            Context::getContext()->link->getModuleLink('agcustomers', 'fbRedirect', ['back' => 'order-opc'])
        ];

        $this->context->smarty->assign(array(
            'tutorial_file' => _PS_MODULE_DIR_ . $this->name . '/views/templates/admin/tutorial_br.tpl',
            'img01' => Media::getMediaPath($this->_path . '/views/img/tutorial_01_br.png'),
            'img02' => Media::getMediaPath($this->_path . '/views/img/tutorial_02_br.png'),
            'img03' => Media::getMediaPath($this->_path . '/views/img/tutorial_03_br.png'),
            'img04' => Media::getMediaPath($this->_path . '/views/img/tutorial_04_br.png'),
            'shop_url' => $this->context->shop->getBaseUrl(),

            'redirectLinks' => $redirectLinks
        ));

        $this->context->controller->addJs(array(
            $this->_path . '/views/js/configuration.js',
            $this->_path . '/views/js/riot_compiler.min.js'
        ));


        $this->context->controller->addCss(array(
            $this->_path . 'views/css/loadingOverlay.css',
            $this->_path . '/views/css/configuration.css'
        ));

        $html = $this->display(_PS_MODULE_DIR_ . $this->name, 'views/templates/admin/configuration.tpl');
        return $html . $this->display(_PS_MODULE_DIR_ . $this->name, 'views/templates/admin/ps-tags.tpl');
    }

    public function hookDisplayHeader()
    {
        $this->context->controller->addJs(array(
            $this->_path . '/views/js/loadingOverlay.js',
            $this->_path . '/views/js/jquery.mask.min.js'
        ));

        if ($this->ps16) {
            //trata do formulário de cadastro
            $this->context->controller->addJs($this->_path . '/views/js/registration.js');
        } else {
            $this->context->controller->addJs($this->_path . '/views/js/registration.ps17.js');
        }

        //verifica se a página atual é o formulário de cadastro
        $reflectedClass = new ReflectionClass($this->context->controller);
        $property = $reflectedClass->getProperty('template');
        $property->setAccessible(true);

        $template = $property->getValue($this->context->controller);        

        $display_facebook_button = false;
        if ($this->ps17 && ($template == 'customer/registration.tpl' || $template == "customer/authentication.tpl" || $this->context->controller->php_self === 'order' || $this->context->controller->php_self === 'identity')) {
            $display_facebook_button = true;
        }

        if ($this->ps16 && ($this->context->controller->php_self === 'authentication' || $this->context->controller->php_self === 'order-opc')) {
            $display_facebook_button = true;
        }

        if ($this->ps17) {
            $this->context->controller->addCss([
                $this->_path . 'views/css/loadingOverlay.css',
                $this->_path . 'views/css/front.css'
            ]);
        }

        if ($display_facebook_button) {
            $fb_data = [
                'app_id' => Configuration::get('AGCUSTOMERS_FACEBOOK_APP_ID'),
                'app_secret' => Configuration::get('AGCUSTOMERS_FACEBOOK_SECRET_KEY'),
                'default_graph_version' => Configuration::get('AGCUSTOMERS_FACEBOOK_OG_VERSION')
            ];

            if ($fb_data['app_id'] && $fb_data['app_secret'] && $fb_data['default_graph_version']) {
                $fb = new Facebook\Facebook([
                    'app_id' => Configuration::get('AGCUSTOMERS_FACEBOOK_APP_ID'),
                    'app_secret' => Configuration::get('AGCUSTOMERS_FACEBOOK_SECRET_KEY'),
                    'default_graph_version' => Configuration::get('AGCUSTOMERS_FACEBOOK_OG_VERSION')
                ]);

                $helper = $fb->getRedirectLoginHelper();

                $actual_link = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

                $permissions = ['email']; // Optional permissions

                $loginUrl = $helper->getLoginUrl($this->context->link->getModuleLink($this->name, 'fbRedirect', array('back' => $this->context->controller->php_self)), $permissions);
                
           
                Media::addJsDef(array(
                    'agcustomers_authentication_url' => $loginUrl,
                    'agcustomers_facebook_text' => $this->l('Enter with Facebook', 'base')
                ));

                $this->context->smarty->assign(array(
                    'agcustomers_authentication_url' => $loginUrl,
                    'agcustomers_facebook_text' => $this->l('Enter with Facebook', 'base')
                ));

                //não exibe o botão de login pelo facebook na tela de informações pessoais ou se o usuário estiver na tela de cadastro
                //já tendo sido redirecionado pelo facebook
                if ($this->context->controller->php_self !== 'identity' || !Tools::getIsSet('firstname')) {
                    if ($this->ps17) {
                        $this->context->controller->addJs(array(
                            $this->_path . '/views/js/fb_login.js'
                        ));
                    } elseif ($this->ps16) {
                        $this->context->controller->addJs(array(
                            $this->_path . '/views/js/fb_login.ps16.js'
                        ));
                    }
                }
            }
        }

        if ($this->ps16) {
            $this->context->controller->addCss(
                $this->_path . '/views/css/front.ps16.css'
            );
        }

        $options = $this->getOptions();
        $customer_data = $this->getCustomerData();

        Media::addJsDef(array(
            'agcustomers_address_autocomplete' => true,
            'agcustomers_district_field' => 'address2',

            'agcustomers_address_search_url' => $this->context->link->getModuleLink('agcustomers', 'AddressSearch'),
            'agcustomers_insert_customer_fields' => (bool) Configuration::get('AGCUSTOMERS_INSERT_CUSTOMER_FIELDS'),
            'agcustomers_insert_rg_field' => (bool) Configuration::get('AGCUSTOMERS_INSERT_RG_FIELD'),
            'agcustomers_insert_company_fields' => (bool) Configuration::get('AGCUSTOMERS_INSERT_COMPANY_FIELDS'),
            'agcustomers_insert_number_field' => true,
            'agcustomers_require_number_field' => (bool) Configuration::get('AGCUSTOMERS_REQUIRE_NUMBER_FIELD'),
            'agcustomers_number_translation' => $this->l('Number', 'base'),
            'agcustomers_cpf' => $this->context->customer->cpf,
            'agcustomers_rg' => $this->context->customer->rg,
            'agcustomers_company_name' => $this->context->customer->company_name,
            'agcustomers_cnpj' => $this->context->customer->cnpj,
            'agcustomers_ie' => $this->context->customer->ie,
            'agcustomers_force_b2b_fields' => (bool) Configuration::get('AGCUSTOMERS_FORCE_B2B_FIELDS'),
            'agcustomers_mask_birthday_input' => true,
            'agcustomers_mask_birthday_format' => $this->context->language->date_format_lite,
            'agcustomers_mask_postcode_input' => true,

            'agcustomers_required_phone' => (bool)Module::isInstalled('agpagseguro') && (bool)Module::isEnabled('agpagseguro'),
            'agcustomers_required_birthday'     => (bool)Module::isInstalled('agpagseguro') && (bool)Module::isEnabled('agpagseguro'),
            'agcustomers' => [
                'urls' => [
                    'ajaxRequests' => $this->context->link->getModuleLink('agcustomers', 'ajaxRequests'),
                    'facebook' => $this->context->link->getModuleLink('agcustomers', 'facebook'),
                    'acustomers_facebook_image' => $this->context->shop->getBaseURL(true) .'modules/' . $this->name . '/views/img/facebook_logo.png'
                ],
                'translations' => [
                    'type_person' => $this->l('Person Type', 'base')
                ],
                'fields' => $options['fields'],
                'type_persons' => $options['type_person'],
                'id_lang' => $this->context->language->id,
                'customer_data' => $customer_data
            ]
        ));

        if (Tools::getValue('id_address')) {
            $address = new Address(Tools::getValue('id_address'));
            Media::addJsDef(array(
                'agcustomers_address_number' => $address->number
            ));
        }

        $this->context->controller->addJs($this->_path . '/views/js/address_autocomplete.js');

        if (Tools::getValue('agcustomers_error') === 'user_denied') {
            $this->context->controller->errors[] = $this->l('You did\'t authorize the Facebook app', 'base');
        }

        $customer = $this->context->customer;
        if (Validate::isLoadedObject($customer) && !$this->isValidCustomer($customer->id)) {
            $this->context->controller->errors[] = $this->displayInvalidCustomerWarning();
        }

        if ($this->ps17) {
            //validação dos endereços do carrinho

            //checkout
            if (isset($this->context->controller->php_self) && $this->context->controller->php_self === 'order') {
                $cart = $this->context->cart;
                if (Validate::isLoadedObject($cart) && $cart->id_address_delivery && !$this->isValidAddress($cart->id_address_delivery)) {
                    $this->context->controller->errors[] = $this->displayInvalidAddressWarning($cart, 'delivery');
                }

                if (Validate::isLoadedObject($cart) && $cart->id_address_invoice && $cart->id_address_delivery != $cart->id_address_invoice  && !$this->isValidAddress($cart->id_address_invoice)) {
                    $this->context->controller->errors[] = $this->displayInvalidAddressWarning($cart, 'invoice');
                }
            }
            //página de endereços ou checkout
            if (isset($this->context->controller->php_self) && in_array($this->context->controller->php_self, ['address', 'order'])) {
                $this->context->controller->addJs([$this->_path . 'views/js/address.js']);
            }
        }
    }

    public function hookDisplayBackOfficeHeader()
    {
        $return = '<script type="text/javascript">';
        if ($this->context->controller->controller_name === 'AdminOrders' && Tools::getIsSet('id_order')) {
            $this->context->controller->addJs(array(
                $this->_path . '/views/js/admin_orders.js'
            ));

            $order = new Order(Tools::getValue('id_order'));
            $customer_data = $this->getCustomerData($order->id_customer);

            $return .= "var agcustomers_data = '" . json_encode($customer_data) . "';";
        } elseif ($this->context->controller->controller_name === 'AdminCustomers') {
            $customer = $this->context->customer;

            if (Validate::isLoadedObject($customer)) {
                $return .= "var agcustomers_cpf = '{$customer->cpf}';";
                $return .= "var agcustomers_rg = '{$customer->rg}';";
                $return .= "var agcustomers_cnpj = '{$customer->cnpj}';";
                $return .= "var agcustomers_ie = '{$customer->ie}';";
                $return .= "var agcustomers_company_name = '{$customer->company_name}';";
            } else {
                $return .= "var agcustomers_cpf = '';";
                $return .= "var agcustomers_rg = '';";
                $return .= "var agcustomers_cnpj = '';";
                $return .= "var agcustomers_ie = '';";
                $return .= "var agcustomers_company_name = '';";
            }

            if (version_compare(_PS_VERSION_, '1.7', '<')) {
                $this->context->controller->addJquery();
                $this->context->controller->addJS([
                    $this->_path . '/views/js/jquery.mask.min.js',
                    $this->_path . '/views/js/admin_customers_view.1.6.js',
                    $this->_path . '/views/js/admin_customers_edit.1.6.js'
                ]);
            } elseif (version_compare(_PS_VERSION_, '1.7.6', '<')) {
                $this->context->controller->addJquery();
                $this->context->controller->addJS([
                    $this->_path . '/views/js/jquery.mask.min.js',
                    $this->_path . '/views/js/admin_customers_view.js',
                    $this->_path . '/views/js/admin_customers_edit.js'
                ]);
            } else {
                $this->context->controller->addJS([
                    __PS_BASE_URI__ . $this->context->controller->admin_webpath . '/themes/new-theme/public/main.bundle.js',
                    $this->_path . '/views/js/jquery.mask.min.js',
                    $this->_path . '/views/js/admin_customers_view.1.7.6.js',
                    $this->_path . '/views/js/admin_customers_edit.1.7.6.js'
                ]);
            }
        } elseif ($this->context->controller->controller_name === 'AdminAddresses' && (Tools::getIsSet('updateaddress') || Tools::getIsSet('addaddress'))) {
            $this->context->controller->addJs(
                $this->_path . 'views/js/admin_address.js'
            );

            $address = new Address(Tools::getValue('id_address'));
            $return .= "var agcustomers_address_number = " . (int)$address->number . ";";
        }

        $return .= "var agcustomers_url_load_options = '" . $this->context->link->getAdminLink('AdminAgCustomersLoadOptions') . "'";
        $return .= '</script>';

        return $return;
    }

    public function hookDisplayAdminOrderContentOrder($data)
    {
        if (Configuration::get('AGCUSTOMERS_1_4_5')) {
            $insert_customer_fields = Configuration::get('AGCUSTOMERS_INSERT_CUSTOMER_FIELDS');
            $insert_rg_field = Configuration::get('AGCUSTOMERS_INSERT_RG_FIELD');
            $insert_company_fields = Configuration::get('AGCUSTOMERS_INSERT_COMPANY_FIELDS');
        } else {
            //retrocompatibility
            $insert_additional_fields = Configuration::get('insert_additional_fields');
        }


        if ((@$insert_additional_fields || @$insert_customer_fields || @$insert_rg_field || @$insert_company_fields) === false) {
            return false;
        }

        $customer = $data['customer'];

        $return = '';
        $return .= '<script type="text/javascript">';
        $return .= 'var agcustomer_cpf="' . $customer->cpf . '";';
        $return .= 'var agcustomer_rg="' . $customer->rg . '";';
        $return .= 'var agcustomer_company_name="' . $customer->company_name . '";';
        $return .= 'var agcustomer_cnpj="' . $customer->cnpj . '";';
        $return .= 'var agcustomer_ie="' . $customer->ie . '";';
        $return .= '</script>';

        return $return;
    }

    //adiciona os campos de cpf, rg, nome da empresa e demais no formulário de cadastro
    public function hookAdditionalCustomerFormFields()
    {
        if (Module::isInstalled('onepagecheckoutps') && Module::isEnabled('onepagecheckoutps') && @$this->context->controller->php_self == 'order') {
            return;
        }

        $fields = $this->getFields();
        $return = [];


        $type_persons = $this->getOptions()['type_person'];
        $active_type_persons = $this->getActiveTypePersons();

        // if (count($active_type_persons) > 1) {
            $obj = (new FormField)
                ->setName('person_type')
                ->setType('radio-buttons')
                ->setLabel($this->l('Person Type', 'base'));

            //se houver só um tipo de pessoa, ele não deve ser marcado como origatório, pois a opção de tipo de pessoa não é exibida no front,
            //e campos ocultos de formulários não podem ser obrigatórios.
            if (count($active_type_persons) > 1) {
                $obj->setRequired(true);
            }
                
            foreach ($active_type_persons as $type_person) {
                if (is_array($type_person['label'])) {
                    if (isset($type_person['label'][$this->context->language->id])) {
                        $label = $type_person['label'][$this->context->language->id];
                    } else {
                        $label = array_pop($type_person['label']);
                    }
                } else {
                    $label = $type_person['label'];
                }

                $obj->addAvailableValue($type_person['name'], $label);
            }
            $return[] = $obj;
        // } elseif (count($active_type_persons)) {
        //     $obj = (new FormField)
        //         ->setName('person_type')
        //         ->setType('hidden')
        //         ->setLabel('teste')
        //         ->setValue($active_type_persons[0]['name']);
        //     $return[] = $obj;
        // }

        foreach ($fields['customer'] as $field) {
            if (!@$field['insert']) { 
                continue;
            }

            $obj = (new FormField)
                ->setName($field['name'])
                ->setType('text');
            
            //se o formulário de criação de conta tiver sido submetido não marca o campo como obrigatório,
            //porque isso bloqueará o cadastro
            if (!Tools::isSubmit('submitCreate')) {
                $obj->setRequired(true);
            }

            if (is_array($field['label'])) { 
                if (isset($field['label'][$this->context->language->id])) {
                    $obj->setLabel($field['label'][$this->context->language->id]);
                } else {
                    $label = array_pop($field['label']);
                    $obj->setLabel($label);
                }
            } else {
                $obj->setLabel($field['label']);
            }

            $return[] = $obj;
        }

        return $return;
    }

    public function hookActionAdminAddressesFormModifier($params)
    {
        if ($this->context->language->iso_code == 'br' && Configuration::get('AGCUSTOMERS_INSERT_NUMBER_FIELD')) {
            $fields = &$params['fields'];
            $fields[0]['form']['input'][] = array(
                'type' => 'text',
                'name' => 'number',
                'label' => 'Número',
                'required' => (bool) Configuration::get('AGCUSTOMERS_REQUIRE_NUMBER_FIELD'),
                'col' => 1
            );

            if (version_compare(_PS_VERSION_, '1.7', '>=')) {
                $params['fields_value']['number'] = $params['object']->number;
            } else {
                $address = new Address(Tools::getValue('id_address'));
                $params['fields_value']['number'] = $address->number;
            }
        }
    }

    public function hookActionObjectCustomerAddAfter($params)
    {
        $customer = $params['object'];

        //cliente cadastrado pelo formulário do BO
        if (@$this->context->controller->controller_name === 'Admin' && !$customer->cpf) {
            $customer->cpf = Tools::getValue('cpf');
            $customer->cnpj = Tools::getValue('cnpj');
            $customer->rg = Tools::getValue('rg');
            $customer->ie = Tools::getValue('ie');
            $customer->company_name = Tools::getValue('company_name');

            $customer->update();
        }
    }

    public function hookActionObjectCustomerUpdateAfter($params)
    {
        $customer = $params['object'];

        //cliente atualizado pelo formulário do BO
        if (@$this->context->controller->controller_name === 'Admin') {
            static $saving;

            if ($saving) {
                return;
            }

            $saving = 1;

            $customer->cpf = Tools::getValue('cpf');
            $customer->cnpj = Tools::getValue('cnpj');
            $customer->rg = Tools::getValue('rg');
            $customer->ie = Tools::getValue('ie');
            $customer->company_name = Tools::getValue('company_name');

            $customer->update();
        }
    }

    public function hookPaymentTop()
    {
        if (
            file_exists(_PS_MODULE_DIR_ . 'onepagecheckoutps/onepagecheckoutps.php') &&
            Module::isInstalled('onepagecheckoutps') &&
            Module::isEnabled('onepagecheckoutps')
        ) {
            return;
        }

        if (!$this->isValidCustomer($this->context->customer->id)) {
            Tools::redirect($this->context->link->getPageLink('identity'));
        }

        if (!$this->isValidAddress($this->context->cart->id_address_delivery)) {
            $this->context->controller->errors[] = 'O seu endereço de entrega está incompleto.';
            $this->context->controller->redirectWithNotifications($this->context->link->getPageLink('address', true, null, ['id_address' => $this->context->cart->id_address_delivery]));
        }

        if (!$this->isValidAddress($this->context->cart->id_address_invoice)) {
            $this->context->controller->errors[] = 'O seu endereço de faturamento está incompleto.';
            $this->context->controller->redirectWithNotifications($this->context->link->getPageLink('address', true, null, ['id_address' => $this->context->cart->id_address_invoice]));
        }
    }


    public function isValidCustomer($id_customer)
    {
        $sql = new DbQuery;
        $sql->from('customer')->where('id_customer=' . (int)$id_customer);
        $customer_data = Db::getInstance()->getRow($sql);

        $active_type_persons = $this->getActiveTypePersons();
        if (empty($customer_data['person_type'])) {
            return count($active_type_persons) == 0;
        }

        $fields = $this->getFields();
        foreach ($fields['customer'] as $field) {
            if (@$field['required'][$customer_data['person_type']] && !$customer_data[$field['name']]) {
                return false;
            }
        }

        return true;
    }

    public function isValidAddress($id_address)
    {
        $sql = new DbQuery;
        $sql->from('address')->where('id_address=' . (int)$id_address);
        $address_data = Db::getInstance()->getRow($sql);

        $fields = $this->getFields();
        foreach ($fields['address'] as $field) {
            if (@$field['required'] && !$address_data[$field['name']]) {
                return false;
            }
        }

        return true;
    }

    public function displayInvalidCustomerWarning()
    {
        return $this->display($this->_path, 'invalid_customer_warning.tpl');
    }

    public function displayInvalidAddressWarning(Cart $cart, $type_address)
    {
        $this->context->smarty->assign([
            'cart_obj' => $cart,
            'type_address' => $type_address
        ]);
        
        return $this->display($this->_path, 'invalid_address_warning.tpl');
    }
    

    public function loadMappings()
    {
        $this->district_mapping = new AgColumnMapping();
        $this->district_mapping->setData(array(
            'table_name' => 'address',
            'configuration_name' => 'agcustomers_district'
        ));
    }

    public function getDistrictMapping()
    {
        return $this->district_mapping;
    }

    public function isBrazilEnabled()
    {
        $brazil = new Country(Country::getByIso('br'));
        return $brazil->active;
    }


    public function getFields()
    {
        $options = $this->getOptions();
        return $options['fields'];
    }

    public function getOptions()
    {
        if ($this->auth()) {
            $options = Configuration::get('AGCUSTOMERS_CONFIG');
            if (empty($options)) {
                $options = $this->getDefaultOptions();
            } else {
                $options = unserialize($options);
            }
        } else {
            $options = $this->getUnauthenticatedOptions();
        }

        return $options;
    }

    public function getActiveTypePersons()
    {
        $type_persons = $this->getOptions()['type_person'];
        $active_type_persons = [];

        foreach ($type_persons as $type_person) {
            if ($type_person['active']) {
                $active_type_persons[] = $type_person;
            }
        }

        return $active_type_persons;
    }

    public function getCustomerData($id_customer = null)
    {
        if (!is_null($id_customer)) {
            $customer = new Customer($id_customer);
        } else {
            $customer = $this->context->customer;
        }

        if (Validate::isLoadedObject($customer)) {
            $sql = new DbQuery;
            $sql->from('customer')
                ->where('id_customer=' . (int)$customer->id);

            $db_data = Db::getInstance()->getRow($sql);

            return $db_data;
        }

        return (array) $customer;
    }

    public function getUnauthenticatedOptions()
    {
        return [
            'fields' => [
                'customer' => [
                    [
                        'name' => 'cpf',
                        'label' => 'CPF',
                        'mask' => '000.000.000-00',
                        'active' => true,
                        'required' => [
                            'pf' => true,
                        ],
                        'insert' => [
                            'pf' => true,
                        ]
                    ],
                ],
                'address' => [
                    [
                        'label' => 'Nome',
                        'name' => 'firstname',
                        'required' => true
                    ],
                    [
                        'label' => 'Sobrenome',
                        'name' => 'lastname',
                        'required' => true
                    ],
                    [
                        'label' => 'Endereço',
                        'name' => 'address1',
                        'required' => true
                    ],
                    [
                        'label' => 'Número',
                        'name' => 'number',
                        'required' => true
                    ],
                    [
                        'label' => 'address2',
                        'name' => 'address2',
                        'required' => true
                    ],
                    [
                        'label' => 'Complemento',
                        'name' => 'other',
                        'required' => false
                    ],
                    [
                        'label' => 'CEP',
                        'name' => 'postcode',
                        'required' => true
                    ],
                    [
                        'label' => 'Cidade',
                        'name' => 'city',
                        'required' => true
                    ],
                    [
                        'label' => 'Estado',
                        'name' => 'id_state',
                        'required' => true
                    ],
                    [
                        'label' => 'País',
                        'name' => 'id_country',
                        'required' => true
                    ],
                    [
                        'label' => 'Telefone',
                        'name' => 'phone',
                        'required' => false
                    ],
                    [
                        'label' => 'Telefone Celular',
                        'name' => 'phone_mobile',
                        'required' => true
                    ]
                ]
            ],
            'type_person' => [
                [
                    'name' => 'pf',
                    'label' => 'Pessoa Física',
                    'active' => true
                ],
                [
                    'name' => 'pj',
                    'label' => 'Pessoa Jurídica',
                    'active' => false
                ],
                [
                    'name' => 'nbr',
                    'label' => 'Pessoa Estrangeira',
                    'active' => false
                ]
            ]
        ];
    }

    public function getDefaultOptions()
    {
        return [
            'fields' => [
                'customer' => [
                    [
                        'name' => 'cpf',
                        'label' => 'CPF',
                        'mask' => '000.000.000-00',
                        'active' => true,
                        'required' => [
                            'pf' => true,
                            'pj' => true,
                            'nbr' => false
                        ],
                        'insert' => [
                            'pf' => true,
                            'pj' => true,
                            'nbr' => false
                        ]
                    ],
                    [
                        'name' => 'rg',
                        'label' => 'RG',
                        'active' => true,
                    ],
                    [
                        'name' => 'company_name',
                        'label' => 'Razão Social',
                        'active' => true,
                    ],
                    [
                        'name' => 'cnpj',
                        'label' => 'CNPJ',
                        'active' => true,
                        'mask' => '00.000.000/0000-00',
                        'required' => [
                            'pf' => false,
                            'pj' => true,
                            'nbr' => false
                        ],
                        'insert' => [
                            'pf' => false,
                            'pj' => true,
                            'nbr' => false
                        ]
                    ],
                    [
                        'name' => 'ie',
                        'label' => 'Inscrição Estadual',
                        'active' => true,
                    ],
                ],
                'address' => [
                    [
                        'label' => 'Nome',
                        'name' => 'firstname',
                        'required' => true
                    ],
                    [
                        'label' => 'Sobrenome',
                        'name' => 'lastname',
                        'required' => true
                    ],
                    [
                        'label' => 'Endereço',
                        'name' => 'address1',
                        'required' => true
                    ],
                    [
                        'label' => 'Número',
                        'name' => 'number',
                        'required' => true
                    ],
                    [
                        'label' => 'address2',
                        'name' => 'address2',
                        'required' => true
                    ],
                    [
                        'label' => 'Complemento',
                        'name' => 'other',
                        'required' => false
                    ],
                    [
                        'label' => 'CEP',
                        'name' => 'postcode',
                        'required' => true
                    ],
                    [
                        'label' => 'Cidade',
                        'name' => 'city',
                        'required' => true
                    ],
                    [
                        'label' => 'Estado',
                        'name' => 'id_state',
                        'required' => true
                    ],
                    [
                        'label' => 'País',
                        'name' => 'id_country',
                        'required' => true
                    ],
                    [
                        'label' => 'Telefone',
                        'name' => 'phone',
                        'required' => false
                    ],
                    [
                        'label' => 'Telefone Celular',
                        'name' => 'phone_mobile',
                        'required' => true
                    ]
                ]
            ],
            'type_person' => [
                [
                    'name' => 'pf',
                    'label' => 'Pessoa Física',
                    'active' => true
                ],
                [
                    'name' => 'pj',
                    'label' => 'Pessoa Jurídica',
                    'active' => true
                ],
                [
                    'name' => 'nbr',
                    'label' => 'Pessoa Estrangeira',
                    'active' => true
                ]
            ]
        ];
    }

    public function createCustomerColumns($inputs)
    {
        foreach ($inputs as $input) {
            $sql = 'SELECT COLUMN_NAME FROM information_schema.COLUMNS WHERE TABLE_SCHEMA="' . pSQL(_DB_NAME_) . '" AND TABLE_NAME="' . pSQL(_DB_PREFIX_ . 'customer') . '" AND COLUMN_NAME="' . pSQL($input['name']) . '"';
            $exists = Db::getInstance()->getValue($sql, true, false);
            if ($exists) {
                continue;
            }

            $sql = 'ALTER TABLE ' . _DB_PREFIX_ . 'customer ADD COLUMN ' . $input['name'] . ' varchar(255)';
            Db::getInstance()->execute($sql);
        }
    }
}
