<?php
class Cart extends CartCore
{
    public function getDeliveryOptionList(Country $default_country = null, $flush = false)
    {
        $delivery_options_list = parent::getDeliveryOptionList($default_country, $flush);
        foreach ($delivery_options_list as $id_address => &$delivery_option) {
            foreach ($delivery_option as $key => &$value) {
                foreach ($value['carrier_list'] as $carrier_id => &$carrier_shipping_info) {
                    $instance = $carrier_shipping_info['instance'];

                    if ($instance->external_module_name == '') {
                        continue;
                    }
                    
                    $module_name = $instance->external_module_name;

                    if (class_exists($module_name)) {
                        $obj = new $module_name;
                    }

                    if (!method_exists($obj, 'getDelay')) {
                        continue;
                    }

                    $delay = $obj::getDelay($instance->id);
                    
                    if ($delay) {
                        $qtt = count($instance->delay);

                        for ($i=0; $i<$qtt; $i++) {
                            $instance->delay[$i] = $delay;
                        }
                    }
                }
            }
        }

        return $delivery_options_list;
    }
}
